/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedona.manifest.KitManifest;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.ir.IrReader;
import sedonac.ir.IrType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReadKits
extends CompilerStep {
    protected boolean autoMountKitIntoNamespace;

    public void run() {
        try {
            this.log.info("  ReadKits [" + this.compiler.kits.length + " kits]");
            int n = 0;
            while (n < this.compiler.kits.length) {
                this.readKit(this.compiler.kits[n]);
                ++n;
            }
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    public void readKit(IrKit irKit) {
        if (irKit.file == null) {
            throw new IllegalStateException("Must set IrKit.file before reading");
        }
        if (!irKit.file.exists()) {
            throw this.err("Cannot find kit '" + irKit.file + '\'', irKit.loc);
        }
        File file = irKit.file.file;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("manifest.xml");
            if (zipEntry == null) {
                throw this.err("Missing 'manifest.xml' manifest", new Location(file));
            }
            this.readManifest(new Location(file, zipEntry), irKit, zipFile.getInputStream(zipEntry));
            ArrayList<IrType> arrayList = new ArrayList<IrType>();
            HashMap<String, IrType> hashMap = new HashMap<String, IrType>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry2 = enumeration.nextElement();
                String string = zipEntry2.getName();
                if (!string.endsWith(".ir")) continue;
                IrType irType = this.readType(new Location(file, zipEntry2), irKit, zipFile.getInputStream(zipEntry2));
                hashMap.put(irType.name, irType);
                arrayList.add(irType);
            }
            irKit.types = arrayList.toArray(new IrType[arrayList.size()]);
            irKit.typesByName = hashMap;
            zipFile.close();
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot read kit file", new Location(file), (Throwable)exception);
        }
        if (this.autoMountKitIntoNamespace) {
            this.ns.mount(irKit);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readManifest(Location location, IrKit irKit, InputStream inputStream) throws Exception {
        try {
            try {
                XElem xElem = XParser.make((String)location.file, (InputStream)inputStream).parse();
                KitManifest kitManifest = new KitManifest(irKit.name);
                kitManifest.decodeXml(xElem);
                irKit.manifest = kitManifest;
                irKit.version = kitManifest.version;
            }
            catch (XException xException) {
                throw this.err(xException);
            }
            catch (CompilerException compilerException) {
                throw compilerException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw this.err("Cannot read kit.xml manifest", location, (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var5_11 = null;
        }
        inputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IrType readType(Location location, IrKit irKit, InputStream inputStream) throws Exception {
        IrType irType;
        try {
            try {
                irType = new IrReader(this.compiler, location, inputStream).readType(irKit);
                Object var5_5 = null;
            }
            catch (CompilerException compilerException) {
                throw compilerException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw this.err("Cannot read kit.xml manifest", location, (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return irType;
    }

    private final /* synthetic */ void this() {
        this.autoMountKitIntoNamespace = true;
    }

    public ReadKits(Compiler compiler) {
        super(compiler);
        this.this();
        this.autoMountKitIntoNamespace = true;
    }
}

